<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['id'])) {
    header('Location: cours.php');
}

$id = $_GET['id'];

if (isset($_GET['supprimer'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();

        $requete = $bdd->prepare('DELETE FROM enseigne_le_cours WHERE id_cours=:cours');
        $requete->bindParam(':cours', $cours_id);
        $requete->execute();

        $requete = $bdd->prepare('DELETE FROM coefficient WHERE id_cours3=:cours');
        $requete->bindParam(':cours', $id);
        $requete->execute();

        $requete = $bdd->prepare('DELETE FROM cours WHERE id_cours=:cours');
        $requete->bindParam(':cours', $id);
        $requete->execute();

        $bdd->commit();

        header('Location: cours.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('UPDATE cours SET nom_cours=:nom, id_groupe2=:id_groupe WHERE id_cours=:id');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':id_groupe', $_POST['groupe_id']);
        $requete->bindParam(':id', $id);
        $requete->execute();

        $total = 0;
        for ($i = 1; $i < 6; $i++) {
            if ($_POST['coeff'.$i] != '') {
                $total += $_POST['coeff'.$i];
            }
        }

        if ($total != 1) {
            throw new Exception('La somme des coefficients ne fait pas 1');
        }

        $requete = $bdd->prepare('DELETE FROM enseigne_le_cours WHERE id_cours=:cours');
        $requete->bindParam(':cours', $id);
        $requete->execute();

        $delete = true;

        for ($i = 1; $i < 6; $i++) {
            if ($_POST['id_note'.$i] != '' && $_POST['coeff'.$i] != '' && $_POST['note'.$i] != '') {
                $requete = $bdd->prepare('UPDATE coefficient SET type_note=:type_note, coefficient=:coeff WHERE id_note_cours=:id_note');
                $requete->bindParam(':type_note', $_POST['note'.$i]);
                $requete->bindParam(':id_note', $_POST['id_note'.$i]);
                $requete->bindParam(':coeff', $_POST['coeff'.$i]);
                $requete->execute();
            }
            elseif ($_POST['coeff'.$i] != '' && $_POST['note'.$i] != '') {
                $requete = $bdd->prepare('INSERT INTO coefficient (type_note, id_cours3, coefficient) VALUES (:type_note, :cours, :coeff)');
                $requete->bindParam(':type_note', $_POST['note'.$i]);
                $requete->bindParam(':cours', $id);
                $requete->bindParam(':coeff', $_POST['coeff'.$i]);
                $requete->execute();
            }
        }

        if (!$delete) {
            $requete = $bdd->prepare('DELETE FROM coefficient WHERE id_cours3=:cours');
            $requete->bindParam(':cours', $id);
            $requete->execute();
        }

        for ($i = 1; $i < 6; $i++) {
            if ($_POST['professeur'.$i] != '') {
                $requete = $bdd->prepare('INSERT INTO enseigne_le_cours (id_professeur, id_cours) VALUES (:prof, :cours)');
                $requete->bindParam(':prof', $_POST['professeur'.$i]);
                $requete->bindParam(':cours', $id);
                $requete->execute();
            }
        }

        $bdd->commit();

        header('Location: cours.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

$menu = '';
$requete = $bdd->prepare("SELECT id_professeur, nom_professeur, prenom_professeur FROM professeur");
$requete->execute();
while ( $row = $requete->fetch())
    $menu .= '<option value="'.htmlspecialchars($row['id_professeur']).'">'.htmlspecialchars($row['prenom_professeur'].' '.$row['nom_professeur']).'</option>';

$requete = $bdd->prepare("SELECT id_note_cours, coefficient FROM coefficient WHERE id_cours3=:id");
$requete->bindParam(':id', $id);
$requete->execute();
$ids = $requete->fetchAll();

$requete = $bdd->prepare("SELECT * FROM cours WHERE id_cours=:id");
$requete->bindParam(':id', $id);
$requete->execute();
$cours = $requete->fetch();

include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Modifier un cours - <a href="edition-cours.php?id=<?php echo htmlspecialchars($id) ?>&supprimer">Supprimer ce cours</a> </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom" value="<?php echo htmlspecialchars($cours['nom_cours']); ?>">
                                    <label>Groupe</label>
                                    <select class="form-control" name="groupe_id">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT id, nom FROM groupe");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id']).'">'.htmlspecialchars($row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <label>Professeur 1</label>
                                    <select class="form-control" name="professeur1">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 2</label>
                                    <select class="form-control" name="professeur2">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 3</label>
                                    <select class="form-control" name="professeur3">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 4</label>
                                    <select class="form-control" name="professeur4">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 5</label>
                                    <select class="form-control" name="professeur5">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Note 1</label>
                                    <select class="form-control" name="note1">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <input type="hidden" value="<?php if (isset($ids[0][0])) echo htmlspecialchars($ids[0][0]) ?>" name="id_note1">
                                    <label>Coefficient note 1</label>
                                    <input class="form-control" name="coeff1" value="<?php if (isset($ids[0][1])) echo htmlspecialchars($ids[0][1]) ?>">
                                    <label>Note 2</label>
                                    <select class="form-control" name="note2">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <input type="hidden" value="<?php if (isset($ids[1][0])) echo htmlspecialchars($ids[1][0]) ?>" name="id_note2">
                                    <label>Coefficient note 2</label>
                                    <input class="form-control" name="coeff2" value="<?php if (isset($ids[1][1])) echo htmlspecialchars($ids[1][1]) ?>">
                                    <label>Note 3</label>
                                    <select class="form-control" name="note3">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <input type="hidden" value="<?php if (isset($ids[2][0])) echo htmlspecialchars($ids[2][0]) ?>" name="id_note3">
                                    <label>Coefficient note 3</label>
                                    <input class="form-control" name="coeff3" value="<?php if (isset($ids[2][1])) echo htmlspecialchars($ids[2][1]) ?>">
                                    <label>Note 4</label>
                                    <select class="form-control" name="note4">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <input type="hidden" value="<?php if (isset($ids[3][0])) echo htmlspecialchars($ids[3][0]) ?>" name="id_note4">
                                    <label>Coefficient note 4</label>
                                    <input class="form-control" name="coeff4" value="<?php if (isset($ids[3][1])) echo htmlspecialchars($ids[3][1]) ?>">
                                    <label>Note 5</label>
                                    <select class="form-control" name="note5">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <input type="hidden" value="<?php if (isset($ids[4][0])) echo htmlspecialchars($ids[4][0]) ?>" name="id_note5">
                                    <label>Coefficient note 5</label>
                                    <input class="form-control" name="coeff5" value="<?php if (isset($ids[4][1])) echo htmlspecialchars($ids[4][1]) ?>">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
